/*   Copyright 2022 APPNEXUS INC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

#import <Foundation/Foundation.h>
NS_ASSUME_NONNULL_BEGIN
@interface ANGoogleMediationSettings : NSObject

/**
 Set setIPadMultiScreenSupport to YES if the application will support multiscene in iPad.
 */
+ (void)setIPadMultiSceneSupport:(BOOL)setIPadMultiSceneSupport;
+ (BOOL)getIPadMultiSceneSupport;

/**
 Sets the Google Publisher Provided ID (PPID) to be passed to Google Mediation Adapter.
 This value will be used when making ad requests through Google's mediation.
 
 @param googlePublisherProvidedId The Publisher Provided ID to use in Google mediated ad calls (may be nil to clear)
 */
+ (void)setGooglePublisherProvidedId:(nullable NSString *)googlePublisherProvidedId;

/**
 Returns the Google Publisher Provided ID (PPID) that was set.
 
 @return The Publisher Provided ID to be used in Google mediated ad calls, or nil if not set
 */
+ (nullable NSString *)getGooglePublisherProvidedId;

@end


NS_ASSUME_NONNULL_END
